﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_MutexTypes.h>

#include "profiler_IpcEvent.h"

namespace nn { namespace profiler {

    // Stores IPC events to be processed in a circular array.
    class IpcEventQueue
    {
    public:
        static const int QueueSize = 20;
    public:
        IpcEventQueue();

        void Initialize();
        void Finalize();

        const IpcEventInfo* GetFront();

        bool Push(IpcEventInfo* task);

        void Pop();
        void Clear();

        uint32_t CurrentCount();

    private:
        IpcEventInfo m_queue[QueueSize];
        uint32_t m_current;
        uint32_t m_elements;
        nn::os::MutexType m_mutex;
    };

}} // nn::profiler
