﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_NativeHandleTypes.h>

#include "profiler_IpcEventQueue.h"

namespace nn { namespace profiler {

void SendPcDebugOutput(const char* message, ...);

nn::Result CommSendMessage(uint32_t id, const void* buffer, size_t size, uintptr_t originalAddress, bool callback);
nn::Result CommStartMultipart(uint32_t id, size_t totalSize, uint32_t pieces, bool callback);
nn::Result CommSendMultipart(const void* buffer, size_t size, uintptr_t originalAddress, uint32_t remaining);
nn::Result CommSetTransferMemory(nn::os::NativeHandle handle, uintptr_t origAddr, size_t size, bool managed);
nn::Result CommReleaseTransferMemory();
nn::Result CommSendSampleBufferAsMultipart(uint32_t blockId, size_t size, uint32_t remaining);

IpcEventQueue* GetIpcEventQueue();
void SignalIpcSystemEvent() NN_NOEXCEPT; // defined in profiler_Main.cpp

nn::Result CommCreateNvnFunctionTable(const void* buffer, size_t size);

void SignalAllDataReceived();

} // profiler
} // nn
