﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_EventTypes.h>

namespace nn { namespace profiler { namespace pccom
{
    const int TASKQUEUE_SIZE = 20;

    typedef void (*SendCallback)(uint32_t message, nn::Result result);

    struct TaskItem
    {
        uint32_t m_message;

        uint32_t m_partsRemaining;

        const void* m_data;
        uint32_t m_dataSize;
        bool m_needsFree;

        SendCallback m_taskCallback;
    };

    // Stores PCCOM_Task structures to be processed in a circular array.
    class TaskQueue
    {
    public:
        TaskQueue();

        void Initialize();
        void Finalize();

        const TaskItem* GetFront();

        bool Push(TaskItem* task);

        void Pop();

        bool WaitForItem();
        void ForceReleaseWait();

        uint32_t CurrentCount();

    private:
        TaskItem m_queue[TASKQUEUE_SIZE];
        uint32_t m_current;
        uint32_t m_elements;
        nn::os::MutexType m_mutex;
        nn::os::EventType m_event;
    };

} // pccom
} // profiler
} // nn
