﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#define NN_PROFILER_SAMPLEBYTIME_RATE(x) uint32_t((1000 * 1000 * 1000) / ((x) * 60))

namespace nn { namespace profiler { namespace {

    uint32_t gSampleByTimeRates[]
    {
        NN_PROFILER_SAMPLEBYTIME_RATE(1),
        NN_PROFILER_SAMPLEBYTIME_RATE(10),
        NN_PROFILER_SAMPLEBYTIME_RATE(25),
        NN_PROFILER_SAMPLEBYTIME_RATE(50),
        NN_PROFILER_SAMPLEBYTIME_RATE(75),
        NN_PROFILER_SAMPLEBYTIME_RATE(100),
        NN_PROFILER_SAMPLEBYTIME_RATE(250),
        NN_PROFILER_SAMPLEBYTIME_RATE(500),
        NN_PROFILER_SAMPLEBYTIME_RATE(750),
        NN_PROFILER_SAMPLEBYTIME_RATE(1000),
        NN_PROFILER_SAMPLEBYTIME_RATE(2000),
        NN_PROFILER_SAMPLEBYTIME_RATE(4000),
    };

}}}

