﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/profiler/profiler_Types.h>

namespace nn { namespace profiler {

struct WorkArea;

typedef nn::Result(*ProfilerRecordFuncPtr)(WorkArea* ws);

nn::Result RecordHeartbeat(
    WorkArea* ws,
    Heartbeats heartbeat,
    uint32_t core);

nn::Result RecordData(
    WorkArea* ws,
    uint32_t event,
    nn::os::ThreadId threadId,
    uint64_t id,
    uint64_t *data,
    uint32_t core);

nn::Result RecordCodeBlock(
    WorkArea* ws,
    nn::os::ThreadId threadId,
    uint64_t blockId,
    bool enteredBlock,
    uint32_t core);

nn::Result RecordInstrumentedHit(
    WorkArea* ws,
    nn::os::ThreadId threadId,
    uintptr_t instrumentedAddress,
    bool enteredBlock,
    uint32_t core);

// Functions that can be assigned into the record function list
nn::Result RecordSampleHeader(WorkArea* ws);
nn::Result RecordPerfCounters(WorkArea* ws);
nn::Result RecordPC(WorkArea* ws);
nn::Result RecordStackDepth(WorkArea* ws);
nn::Result RecordStack(WorkArea* ws);
nn::Result RecordDefaultFuncPtr(WorkArea* ws);

} // profiler
} // nn
