﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace profiler {

class Header
{
public:
    Header();

    void Initialize();
    void Finalize();

    void* GetBuffer();
    size_t GetSize();

    void WriteControlValueOnly(uint32_t controlValue);
    void Write(uint32_t controlValue);
    void Write(uint32_t controlValue, uint32_t data1);
    void Write(uint32_t controlValue, uint64_t data1);
    void Write(uint32_t controlValue, uint32_t data1, uint32_t data2);
    void Write(uint32_t controlValue, uint32_t data1, uint32_t data2, uint32_t data3);
    void Write(uint32_t controlValue, uint16_t* dataArray, uint32_t count, uint32_t data2);
    void Write(
        uint32_t controlValue,
        uint32_t data1,
        uint32_t data2,
        uint32_t data3,
        uint32_t data4);

protected:
private:
    void* m_startPtr;
    void* m_curPtr;
};

void InitializeHeaders();
void FinalizeHeaders();

Header* GetMasterHeader();
Header* GetCoreHeader(uint32_t core);


} // profiler
} // nn
