﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/init.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/pcv/pcv.h>

#include <nn/pcie/pcie.h>
#include <nn/pcie/server/pcie_HipcServer.h>

namespace nn { namespace pcie {

// 空の nndiagStartup() を定義
extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    NN_SDK_ASSERT_EQUAL(NN_SYSTEM_THREAD_PRIORITY(pcie, Main), nn::os::GetThreadPriority(nn::os::GetCurrentThread()));
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(pcie, Main));

    NN_SDK_LOG("[pcie]: process start.\n");

    // synchronize with PCV, as it configures clocks
    nn::pcv::Initialize();

    nn::pcie::server::InitializeServer();
    nn::pcie::server::LoopServer();
    nn::pcie::server::FinalizeServer();

    NN_SDK_LOG("[pcie]: process exit.\n");
}

} // namespace pcie
} // namespace nn
