﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/ns/srv/ns_IEventDispatcher.h>
#include <nn/ns/srv/ns_IEventHandler.h>

namespace nn { namespace ns {

    enum Port
    {
        Port_Develop,
        Port_Count
    };

    template<int Count> constexpr int Accumulate(int const (& array)[Count], int offset = 0)
    {
        return ((offset < Count) ? array[offset] + Accumulate(array, offset + 1): 0);
    }

    constexpr int SessionCount[Port_Count] =
    {
        10,
    };
    constexpr int MaxAllSessionCount = Accumulate(SessionCount);

    class MyServerManager
        : public sf::HipcSimpleAllInOneServerManager<MaxAllSessionCount, Port_Count>
        , public srv::IEventDispatcher
    {
    public:
        virtual void AddEventHandler(srv::IEventHandler* pHandler)
        {
            AddUserWaitHolder(pHandler->GetEvent()->GetWaitHolder());
        }
    };

    MyServerManager* GetServerManager();
    void LoopServerWithEventHandler();


}}  // namespace nn::ns

