﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ns_ApplicationManagerMain.h"

#include "ns_DelayedInitializer.h"
#include "ns_SettingUpdater.h"
#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Thread.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/pm/pm_BootModeApi.h>
#include <nn/ns/detail/ns_IVulnerabilityManagerInterface.sfdl.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_WebAppletApi.h>
#include <nn/ns/ns_EcAppletApi.h>
#include <nn/ns/ns_RepairToolApi.h>
#include <nn/ns/ns_SystemUpdateApi.h>
#include <nn/ns/ns_SystemUpdateSystemApi.h>
#include <nn/ns/ns_VulnerabilityApi.h>
#include <nn/ns/srv/ns_ApplicationManagerInterfaceServer.h>
#include <nn/ns/srv/ns_DevelopInterfaceServerFactory.h>
#include <nn/ns/srv/ns_SystemUpdateInterfaceServer.h>
#include <nn/ns/srv/ns_ServiceGetterInterfaceServer.h>
#include <nn/ns/srv/ns_SystemReportManager.h>

#include <nn/nn_SystemThreadDefinition.h>

namespace nn { namespace ns {

namespace {

// ApplicationManagerInterfaceServer のインスタンス
srv::ApplicationManagerInterfaceServer g_ApplicationManagerInterfaceServerInstance;

// ポート毎の ServiceGetter のインスタンス
const Bit32 CapabilityForWebApplet =
    srv::ServiceGetterInterfaceServer::Capability::DocumentAccess |
    srv::ServiceGetterInterfaceServer::Capability::ReadOnlyApplicationRecord |
    srv::ServiceGetterInterfaceServer::Capability::ReadOnlyApplicationControlData;
srv::ServiceGetterInterfaceServer g_ServiceGetterInterfaceServerForWebAppletImpl(&g_ApplicationManagerInterfaceServerInstance, CapabilityForWebApplet);

const Bit32 CapabilityForEcApplet =
    srv::ServiceGetterInterfaceServer::Capability::ContentManagement |
    srv::ServiceGetterInterfaceServer::Capability::DownloadTask |
    srv::ServiceGetterInterfaceServer::Capability::ECommerce;
srv::ServiceGetterInterfaceServer g_ServiceGetterInterfaceServerForEcAppletImpl(&g_ApplicationManagerInterfaceServerInstance, CapabilityForEcApplet);

const Bit32 CapabilityForRetailInteractiveDisplay =
    srv::ServiceGetterInterfaceServer::Capability::AccountProxyForCreation;
srv::ServiceGetterInterfaceServer g_ServiceGetterInterfaceServerForRetailInteractiveDisplayImpl(&g_ApplicationManagerInterfaceServerInstance, CapabilityForRetailInteractiveDisplay);

const Bit32 CapabilityForRepairTool =
    srv::ServiceGetterInterfaceServer::Capability::FactoryReset;
srv::ServiceGetterInterfaceServer g_ServiceGetterInterfaceServerForRepairToolImpl(&g_ApplicationManagerInterfaceServerInstance, CapabilityForRepairTool);

const Bit32 CapabilityForApplicationManager =
    srv::ServiceGetterInterfaceServer::Capability::DocumentAccess |
    srv::ServiceGetterInterfaceServer::Capability::ContentManagement |
    srv::ServiceGetterInterfaceServer::Capability::DownloadTask |
    srv::ServiceGetterInterfaceServer::Capability::ApplicationManager |
    srv::ServiceGetterInterfaceServer::Capability::AccountProxyForCreation |
    srv::ServiceGetterInterfaceServer::Capability::FactoryReset |
    srv::ServiceGetterInterfaceServer::Capability::ApplicationVersion |
    srv::ServiceGetterInterfaceServer::Capability::ECommerce |
    srv::ServiceGetterInterfaceServer::Capability::ReadOnlyApplicationRecord |
    srv::ServiceGetterInterfaceServer::Capability::ReadOnlyApplicationControlData |
    srv::ServiceGetterInterfaceServer::Capability::DynamicRights;
srv::ServiceGetterInterfaceServer g_ServiceGetterInterfaceServerForApplicationManagerImpl(&g_ApplicationManagerInterfaceServerInstance, CapabilityForApplicationManager);


// ポートに登録するサービスオブジェクト
sf::UnmanagedServiceObjectByPointer<ns::detail::IServiceGetterInterface, ns::srv::ServiceGetterInterfaceServer> g_ServiceInterfaceServerForWebApplet(&g_ServiceGetterInterfaceServerForWebAppletImpl);
sf::UnmanagedServiceObjectByPointer<ns::detail::IServiceGetterInterface, ns::srv::ServiceGetterInterfaceServer> g_ServiceInterfaceServerForEcApplet(&g_ServiceGetterInterfaceServerForEcAppletImpl);
sf::UnmanagedServiceObjectByPointer<ns::detail::IServiceGetterInterface, ns::srv::ServiceGetterInterfaceServer> g_ServiceInterfaceServerForRetailInteractiveDisplay(&g_ServiceGetterInterfaceServerForRetailInteractiveDisplayImpl);
sf::UnmanagedServiceObjectByPointer<ns::detail::IServiceGetterInterface, ns::srv::ServiceGetterInterfaceServer> g_ServiceInterfaceServerForRepairTool(&g_ServiceGetterInterfaceServerForRepairToolImpl);
sf::UnmanagedServiceObjectByPointer<ns::detail::IServiceGetterInterface, ns::srv::ServiceGetterInterfaceServer> g_ServiceInterfaceServerForApplicationManager(&g_ServiceGetterInterfaceServerForApplicationManagerImpl);
sf::UnmanagedServiceObjectByPointer<ns::detail::IVulnerabilityManagerInterface, ns::srv::ApplicationManagerInterfaceServer> g_VulnerabilityManagerInterfaceServer(&g_ApplicationManagerInterfaceServerInstance);
sf::UnmanagedServiceObject<ns::detail::ISystemUpdateInterface, ns::srv::SystemUpdateInterfaceServer> g_SystemUpdateInterfaceServer;

class ApplicationManagerServerManager : public nn::sf::HipcSimpleAllInOneServerManager<30, 7>{};
srv::SystemReportManager g_SystemReportManager;

ApplicationManagerServerManager g_ServerManager;
NN_OS_ALIGNAS_THREAD_STACK char g_ServerManagerThreadStack[4096 * 4];
os::ThreadType g_ServerManagerThread;

void ServerManagerThreadFunction(void*)
{
    WaitDelayedInitialization();

    if(nn::pm::GetBootMode() == nn::pm::BootMode_Normal || nn::pm::GetBootMode() == nn::pm::BootMode_Maintenance)
    {
        // ヘッドホン音量設定の更新
        ns::UpdateHeadphoneSettings();
    }

    if(nn::pm::GetBootMode() == nn::pm::BootMode_Normal)
    {
        g_SystemReportManager.Initialize();
    }
    else
    {
        g_SystemReportManager.InitializeForMaintenanceMode();
    }

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_SystemUpdateInterfaceServer.GetImpl().Initialize(&g_SystemReportManager));
    auto requestServerForSystemUpdate = g_SystemUpdateInterfaceServer.GetImpl().GetRequestServer();

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ApplicationManagerInterfaceServerInstance.Initialize(requestServerForSystemUpdate, &g_SystemReportManager));
    nn::ns::srv::GetSharedDevelopInterfaceServerImpl().RegisterProgramLaunchObserver(g_ApplicationManagerInterfaceServerInstance);
    g_ServerManager.LoopAuto();
}

}

void RegisterApplicationManager() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_SystemUpdateInterfaceServer.GetShared(), 10, detail::PortNameForSystemUpdate));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_VulnerabilityManagerInterfaceServer.GetShared(), 10, detail::PortNameForVulnerabilityManager));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_ServiceInterfaceServerForApplicationManager.GetShared(), 10, detail::PortNameForApplicationManager));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_ServiceInterfaceServerForWebApplet.GetShared(), 10, detail::PortNameForWebApplet));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_ServiceInterfaceServerForEcApplet.GetShared(), 10, detail::PortNameForEcApplet));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_ServiceInterfaceServerForRepairTool.GetShared(), 10, detail::PortNameForRepairTool));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_ServiceInterfaceServerForRetailInteractiveDisplay.GetShared(), 10, detail::PortNameForRetailInteractiveDisplay));

    // TODO: 初期化順
    ns::InitializeForSystemUpdateWithObject(g_SystemUpdateInterfaceServer.GetShared());
    ns::InitializeServiceGetterWithObject(g_ServiceInterfaceServerForApplicationManager.GetShared());
    // TODO: DFC で VulnerabilityManager を呼ぶ必要が出てきたら InitializeForVulnerabilityManagerWithObject を作りここで呼んでおくこと
}

void StartApplicationManagerMain() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_ServerManagerThread, ServerManagerThreadFunction, nullptr, g_ServerManagerThreadStack, sizeof(g_ServerManagerThreadStack), NN_SYSTEM_THREAD_PRIORITY(ns, ApplicationManagerIpcSession)));
    nn::os::SetThreadNamePointer(&g_ServerManagerThread, NN_SYSTEM_THREAD_NAME(ns, ApplicationManagerIpcSession));
    nn::os::StartThread(&g_ServerManagerThread);
}

}}
