﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>

namespace nn{ namespace npns{

class SuspendManager
{
public:
    SuspendManager();
    ~SuspendManager();

    void Suspend();
    void Resume();
    bool IsSuspended() const
    {
        return m_Count > 0;
    }

    class SuspendClient
    {
    public:
        NN_IMPLICIT SuspendClient(SuspendManager& manager);
        ~SuspendClient();

        void Suspend();
        void Resume();

    private:
        SuspendManager& m_SuspendManager;
        int32_t m_Count;
    };

    class ScopedSuspender
    {
    public:
        NN_IMPLICIT ScopedSuspender(SuspendClient& client);
        ~ScopedSuspender();

    private:
        SuspendClient& m_client;
    };


private:
    static os::Mutex s_Mutex;
    int32_t m_Count;
};

}}
