﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>
#include <nn/http.h>
#include <nn/http/http_JsonResponse.h>
#include "npns_Common.h"
#include "npns_NotificationTokenConsumer.h"

namespace nn {
namespace npns {

NotificationTokenConsumer::NotificationTokenConsumer(http::ConnectionBroker& cb, DeviceTokenHolder& dth)
    : ResourceConsumerBase(cb, dth)
{
}

Result NotificationTokenConsumer::Create(NotificationToken* pOutToken, const ReceiverId& uid, const char* jid, ApplicationId applicationId)
{
    http::Request req(m_ConnectionBroker);

    req.SetMethodType(http::MethodType_Post);
    SetupRequestParameters(&req, uid, jid, applicationId);
    SetupRequestHeaders(&req);

    int64_t resultCode;
    const nn::http::JsonResponse::ParseRule parseRules[] = {
        { "result_code",        nullptr, http::JsonResponse::ValueType_Int64Force, &resultCode,     sizeof(resultCode) },
        { "notification_token", nullptr, http::JsonResponse::ValueType_String,     pOutToken->data, npns::TokenLength  },
        {}
    };

    Result result = SendRequest(&req, parseRules, resultCode);
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    NN_NPNS_INFO("result_code = %04d\n", resultCode);
    NN_NPNS_INFO("token = %s\n", pOutToken->data);

    return ResultSuccess();
}

Result NotificationTokenConsumer::Destroy(const ReceiverId& uid, const char* jid, ApplicationId applicationId)
{
    http::Request req(m_ConnectionBroker);

    req.SetMethodType(http::MethodType_Delete);
    SetupRequestParameters(&req, uid, jid, applicationId);
    SetupRequestHeaders(&req);

    int64_t resultCode;
    const nn::http::JsonResponse::ParseRule parseRules[] = {
        { "result_code",        nullptr, http::JsonResponse::ValueType_Int64Force, &resultCode,     sizeof(resultCode) },
        {}
    };

    Result result = SendRequest(&req, parseRules, resultCode);
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    NN_NPNS_INFO("result_code = %04d\n", resultCode);

    return ResultSuccess();}

Result NotificationTokenConsumer::SetupRequestParameters(http::Request * pRequest, const ReceiverId & uid, const char * jid, ApplicationId applicationId)
{
    Result result;

    result = pRequest->SetUrlByFormatString("https://consumer." NN_NPNS_SERVER_ENVIRONMENT ".npns.srv.nintendo.net/api/v1/accounts/hac_%016llx%016llx/notification_tokens", uid._data[0], uid._data[1]);
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    result = pRequest->SetPostDataByFormatString("jid=%s&application_id=%016llx", jid, applicationId.value);
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    return ResultSuccess();
}


}
}
