﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/npns/detail/npns_InternalTypes.h>

namespace nn{ namespace npns{

class ClientThread;
class StateMachineThread;
class Router;
class Controller;
class IpcServerManager;
class SystemEventHandlerThread;

class Instance
{
    NN_DISALLOW_COPY(Instance);
    NN_DISALLOW_MOVE(Instance);

private:
    ClientThread& m_ClientThread;
    StateMachineThread& m_StateMachineThread;
    Router& m_Router;
    Controller& m_Controller;
    IpcServerManager& m_IpcServerManager;
    SystemEventHandlerThread & m_SystemEventHandlerThread;
    Statistics& m_Statistics;

public:
    Instance();
    void Initialize();
    void Finalize();

    ClientThread& GetClientThread()
    {
        return m_ClientThread;
    }

    StateMachineThread& GetStateMachineThread()
    {
        return m_StateMachineThread;
    }

    Controller& GetController()
    {
        return m_Controller;
    }

    Router& GetRouter()
    {
        return m_Router;
    }

    IpcServerManager& GetIpcServerManager()
    {
        return m_IpcServerManager;
    }

    SystemEventHandlerThread& GetSystemEventHandlerThread()
    {
        return m_SystemEventHandlerThread;
    }

    Statistics& GetStatistics()
    {
        return m_Statistics;
    }
};

extern Instance& g_Daemon;

}}


