﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>
#include <nn/http.h>
#include <nn/http/http_JsonResponse.h>
#include "npns_Common.h"
#include "npns_ArrivalConsumer.h"

namespace nn {
namespace npns {

ArrivalConsumer::ArrivalConsumer(http::ConnectionBroker& cb, DeviceTokenHolder& dth)
    : ResourceConsumerBase(cb, dth)
{
}

Result ArrivalConsumer::Check(bool* pIsArrived, int32_t* pWait, int32_t* pTry, const char* jid, os::Event* pCancelEvent)
{
    http::Request req(m_ConnectionBroker);

    req.SetMethodType(http::MethodType_Get);
    req.SetCancelEvent(pCancelEvent);
    SetupRequestParameters(&req, jid);
    // DT での認証は無し
    // SetupRequestHeaders(&req);

    int64_t arrived = 0, wait = 0, tryCount = 0;
    const nn::http::JsonResponse::ParseRule parseRules[] = {
        { "arrived", nullptr, http::JsonResponse::ValueType_Int64, &arrived, sizeof(arrived) },
        { "wait",    nullptr, http::JsonResponse::ValueType_Int64, &wait,    sizeof(wait) },
        { "try",     nullptr, http::JsonResponse::ValueType_Int64, &tryCount,sizeof(tryCount) },
        {}
    };

    int64_t resultCode = ResultCode_Success; // result_code は返ってこない
    Result result = SendRequest(&req, parseRules, resultCode);
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    NN_NPNS_INFO("arrived = %lld, wait = %lld, try = %lld\n", arrived, wait, tryCount);
    *pIsArrived = arrived       ? true : false;
    *pWait      = wait     >= 0 ? static_cast<int32_t>(wait)     : 0;
    *pTry       = tryCount >= 0 ? static_cast<int32_t>(tryCount) : 0;

    return ResultSuccess();
}


Result ArrivalConsumer::SetupRequestParameters(http::Request * pRequest, const char * jid)
{
    Result result;

    pRequest->SetUrlPointer("https://broker." NN_NPNS_SERVER_ENVIRONMENT ".npns.srv.nintendo.net/api/v4/arrivals");

    result = pRequest->AddHeaderFormat("X-JID: %s", jid);
    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    return ResultSuccess();
}


}
}
