﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/nfc/server/core/nfc_CoreManager.h>
#include "nfc_Server.h"

namespace
{
    NN_ALIGNAS(4096) char g_HeapMemory[512 * 1024];
    nn::lmem::HeapHandle g_HeapHandle;
}

void* operator new(size_t size)
{
    return nn::lmem::AllocateFromExpHeap(g_HeapHandle, size);
}

void* operator new[](size_t size)
{
    return nn::lmem::AllocateFromExpHeap(g_HeapHandle, size);
}

void operator delete(void* p) NN_NOEXCEPT
{
    nn::lmem::FreeToExpHeap(g_HeapHandle, p);
}

void operator delete[](void* p) NN_NOEXCEPT
{
    nn::lmem::FreeToExpHeap(g_HeapHandle, p);
}

void* Allocate(size_t size) NN_NOEXCEPT
{
    return nn::lmem::AllocateFromExpHeap(g_HeapHandle, size);
}

void Deallocate(void* ptr, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(size);
    nn::lmem::FreeToExpHeap(g_HeapHandle, ptr);
}

extern "C" void nninitStartup()
{
    g_HeapHandle = nn::lmem::CreateExpHeap(
        g_HeapMemory, sizeof(g_HeapMemory), nn::lmem::CreationOption_NoOption);
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    nn::os::ChangeThreadPriority(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_PRIORITY(nfc, Main));
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(nfc, Main));

    nn::fs::SetAllocator(Allocate, Deallocate);

    InitializeServer();
    nn::nfc::server::core::Manager::GetInstance();

    LoopServer();

    FinalizeServer();
}
