﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/sm/sm_UserApi.h>
#include "dmnt_ServerMain.h"
#include "dmnt_Server.h"

#define USE_DMNT

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    nn::Result result = nn::sm::Initialize();
    NN_ABORT_UNLESS(result.IsSuccess(), "result=%08x", result);

    result = nn::dbg::Initialize();
    NN_ABORT_UNLESS(result.IsSuccess(), "result=%08x", result);

    StartServer();

//    Server::Initialize();

    for (;;)
    {
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000) );
    }
}
