﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "creport_Common.h"
#include "creport_ModuleInfo.h"

namespace nn { namespace creport {

    class ThreadInfo
    {
    public:
        ThreadInfo() NN_NOEXCEPT : m_ThreadId(0), m_StackTop(0), m_StackBottom(0), m_StackTraceCount(0)
        {
            std::memset(&m_Context, 0, sizeof(m_Context));
            std::memset(m_StackTrace, 0, sizeof(m_StackTrace));
            std::memset(m_Hash, 0, sizeof(m_Hash));
        }

        bool GetThreadInfo(svc::Handle handle, Bit64 tid, bool is64bit) NN_NOEXCEPT;

        void CalculateHash(const ModuleManager& module) NN_NOEXCEPT;

        Bit64 GetPc() const NN_NOEXCEPT
        {
            return m_Context.pc;
        }

        Bit64 GetLr() const NN_NOEXCEPT
        {
            return m_Context.lr;
        }

        const Bit8* GetHashBuffer() const NN_NOEXCEPT
        {
            return m_Hash;
        }

        size_t GetHashLength() const NN_NOEXCEPT
        {
            return HashLength;
        }

        void AppendToBuffer(InfoBuffer* pOutBuffer) NN_NOEXCEPT;

    private:
        void GetStackRegion(svc::Handle handle) NN_NOEXCEPT;

    private:
        static const int    MaxStackTraceCount = 32;
        static const int    HashLength = 32;

        Bit64               m_ThreadId;
        svc::ThreadContext  m_Context;
        Bit64               m_StackTop;
        Bit64               m_StackBottom;
        Bit64               m_StackTrace[MaxStackTraceCount];
        Bit8                m_StackTraceCount;
        Bit8                m_Hash[HashLength];
    };

    class ThreadManager
    {
    public:
        ThreadManager() NN_NOEXCEPT : m_DebugHandle(svc::INVALID_HANDLE_VALUE), m_ThreadCount(0)
        {
            memset(m_Threads, 0, sizeof(m_Threads));
        }

        void CollectThreadInformation(svc::Handle handle, bool is64bit) NN_NOEXCEPT;

        void AppendToBuffer(InfoBuffer* pOutBuffer) NN_NOEXCEPT;

    private:
        static const int MaxThreadCount = 96;

        svc::Handle m_DebugHandle;
        int32_t     m_ThreadCount;
        ThreadInfo  m_Threads[MaxThreadCount];
    };

}} // nn::creport
