﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nn { namespace creport {

    // ブラックリスト
    const Bit64 BlackList[] = {
        0x0100000000000036, // creport
        0x0100000000001008, // swkbd
        0x010000000000100A, // web
        0x010000000000100B, // shop
        0x0100000000001010, // loginShare
        0x0100000000001011, // wifiWebAuth
        //0x0100000000002064, // DevMenu (test)
    };

    // ホワイトリスト
    const Bit64 WhiteList[] = {
        0x01007ef00011e000,
        0x01000320000cc000,
        0x0100704000b3a000,
        0x0100d87002ee0000,
        0x0100152000022000,
        0x01009b500007c000,
        0x01003c700009c000,
        0x01003bc0000a0000,
        0x0100f8f0000a2000,
        0x010000a00218e000,
        0x0100c5e003b40000,
        0x0100f3400332c000,
        0x0100e95004038000,
        0x0100000000010000,
        0x0100d070040f8000,
        0x01003870040fa000,
        0x010086f0040fc000,
        0x0100069000078000,
        0x01007960049a0000,
        0x010076f0049a2000,
        0x0100ea80032ea000,
        0x01006e800972c000,
        0x01009bf0072d4000,
        //0x01004b9000490000, // sample (test)
    };

    // ダイイング・メッセージ
    const size_t DyingMessageMaxSize = 4096;

    // 暗号化用
    const size_t RsaKeyLength = 256;
    const size_t PublicModulusLength = 256;
    const size_t PublicExponentLength = 3;
    const size_t RsaOaepSeedSize = 32;

    const Bit8 PublicKeyModulus[2][PublicModulusLength] = {
        {
            // for system
            0x96, 0x52, 0x4e, 0xe0, 0xde, 0x49, 0x81, 0x5b, 0x10, 0xfe, 0x97, 0x36, 0xb6, 0x1a, 0x12, 0xa5,
            0xb6, 0x78, 0xd3, 0x1e, 0x85, 0xaa, 0x16, 0x52, 0x97, 0xc9, 0xf7, 0x03, 0x23, 0x88, 0x33, 0x00,
            0xb4, 0x7b, 0x51, 0x0c, 0x2f, 0x8b, 0x8f, 0xa3, 0xdb, 0x6a, 0x88, 0x3c, 0xd0, 0x39, 0xf0, 0x80,
            0x67, 0x79, 0x9e, 0x13, 0xb8, 0x17, 0x88, 0x1a, 0xfb, 0xa4, 0xa5, 0xec, 0x59, 0xf3, 0x23, 0xe7,
            0xa1, 0x1a, 0x2d, 0xf4, 0x23, 0x9c, 0x0e, 0xd5, 0x75, 0x69, 0x42, 0xf6, 0x51, 0x9d, 0xb4, 0x39,
            0x47, 0x5a, 0x12, 0x75, 0xc5, 0xa8, 0x40, 0x46, 0xa6, 0x11, 0x90, 0x64, 0x77, 0xa7, 0xef, 0x52,
            0x80, 0x8d, 0x0a, 0xe8, 0x5a, 0xb2, 0x75, 0xb6, 0x88, 0x7a, 0x7a, 0x34, 0x61, 0x5e, 0x8a, 0xba,
            0xcc, 0xbd, 0x39, 0xd6, 0xdb, 0xea, 0x8b, 0xaa, 0xca, 0x4c, 0x95, 0x59, 0xff, 0xf3, 0x2f, 0x10,
            0x53, 0x07, 0x09, 0x05, 0xb9, 0x4a, 0xb4, 0x03, 0x0e, 0x27, 0x8e, 0x0d, 0x9f, 0x0a, 0xcf, 0x3c,
            0xb1, 0xd2, 0x78, 0x47, 0xc7, 0x0c, 0xe4, 0x11, 0x8f, 0xf7, 0x42, 0x7d, 0x92, 0xba, 0x00, 0x65,
            0x24, 0x59, 0x3e, 0xbd, 0x4f, 0x61, 0x5c, 0x5a, 0x36, 0xe2, 0xf5, 0x84, 0xe9, 0xdf, 0x2a, 0x1f,
            0x21, 0xe8, 0xe9, 0xeb, 0x65, 0x72, 0x5a, 0x63, 0x24, 0xba, 0x4c, 0x9d, 0x7d, 0xba, 0x77, 0x70,
            0x29, 0x4c, 0x6e, 0x85, 0x8d, 0x30, 0x66, 0x5b, 0xed, 0x56, 0x65, 0x81, 0xd1, 0xce, 0x7c, 0xde,
            0xc3, 0xc3, 0xa0, 0x95, 0xc9, 0x52, 0xcf, 0x8b, 0xb2, 0x82, 0xcd, 0xe8, 0x6b, 0xf3, 0xea, 0x6d,
            0x75, 0xa9, 0xc4, 0xc7, 0xb9, 0x9e, 0xc4, 0x3d, 0x78, 0x59, 0x99, 0xaa, 0x14, 0xc4, 0xcb, 0x43,
            0x73, 0xa8, 0x31, 0x2e, 0xb8, 0x5b, 0x23, 0x1f, 0x83, 0x24, 0x3a, 0xed, 0xe5, 0x99, 0xc9, 0x5b
        },
        {
            // for application
            0xb6, 0x0a, 0x00, 0xc8, 0x83, 0x9d, 0xe5, 0xfd, 0x05, 0x45, 0x5a, 0x38, 0x3e, 0xaa, 0xfa, 0xf0,
            0x59, 0xe5, 0x2c, 0x84, 0xe1, 0xa2, 0xde, 0x5b, 0x1a, 0x71, 0xa9, 0x92, 0x1c, 0xf9, 0xc3, 0xec,
            0xc4, 0x3f, 0xd6, 0xef, 0x1b, 0xad, 0x86, 0xb8, 0xce, 0x0f, 0x8b, 0x33, 0x86, 0xb8, 0x87, 0x6c,
            0xee, 0xc3, 0x18, 0xc9, 0x21, 0xd3, 0x7b, 0x91, 0xc7, 0x88, 0xac, 0x95, 0x4b, 0x34, 0x82, 0x49,
            0x55, 0x70, 0x7d, 0x51, 0x2f, 0x0a, 0x86, 0x68, 0x34, 0x85, 0xf5, 0xaa, 0x45, 0xa7, 0x0f, 0x5f,
            0xe4, 0x61, 0xb3, 0x33, 0xe7, 0x83, 0x23, 0x41, 0xde, 0xea, 0xba, 0x49, 0x3d, 0xae, 0xac, 0x09,
            0x3d, 0x70, 0x05, 0x29, 0x92, 0x7d, 0x51, 0x75, 0x8b, 0x87, 0x11, 0x69, 0xaa, 0x83, 0xa5, 0x82,
            0xe4, 0xd5, 0x29, 0x7d, 0xf0, 0x0c, 0x68, 0x68, 0x27, 0x94, 0x5e, 0x49, 0xe4, 0x59, 0x2a, 0xa4,
            0xca, 0x83, 0x04, 0x93, 0x78, 0x9d, 0x8f, 0x10, 0xef, 0x86, 0xc3, 0xbe, 0xee, 0xad, 0xd0, 0xdc,
            0x4f, 0xd2, 0xc8, 0xc5, 0xab, 0x18, 0x1b, 0x95, 0xdb, 0x67, 0x43, 0x60, 0xc8, 0xb7, 0xdd, 0x29,
            0x0a, 0x0a, 0x3b, 0xd3, 0x43, 0x6e, 0x4c, 0x95, 0xa4, 0x1c, 0xe9, 0xbb, 0x9c, 0x6d, 0x3b, 0x56,
            0x86, 0x46, 0x2a, 0x20, 0x5a, 0x6e, 0x8c, 0x78, 0x22, 0x60, 0x81, 0x86, 0x41, 0xa3, 0xe4, 0xa6,
            0x50, 0x86, 0xc8, 0x68, 0x2c, 0x8d, 0x14, 0x0b, 0x0e, 0xd0, 0x88, 0xd9, 0xb9, 0xac, 0x50, 0x7e,
            0x2e, 0xf3, 0x3c, 0xd6, 0xb3, 0x72, 0xce, 0x5b, 0xa0, 0x60, 0x10, 0x46, 0x83, 0x59, 0xa6, 0x01,
            0xe3, 0xee, 0xff, 0xc9, 0xac, 0x04, 0x9c, 0x45, 0x9c, 0xd8, 0x90, 0x01, 0x52, 0x95, 0xf0, 0xb2,
            0x64, 0xc3, 0xf1, 0x7e, 0xba, 0x5f, 0xcb, 0x0e, 0xcf, 0xd0, 0xdb, 0xd8, 0x00, 0xe1, 0xf6, 0x41
        }
    };
    const Bit8 PublicKeyExponent[PublicExponentLength] = { 0x01, 0x00, 0x01 };

}} // nn::creport
