﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <btm_InternalTypes.h>

namespace nn { namespace btm {

//Main向け
void InitializeWorker();
void FinalizeWorker();
void Worker();

//Impl,Main,Queue向け
static const int SIZE_OF_COMMAND_BUFFER=1000;
static const int SIZE_OF_REPORT_BUFFER=1000;
nn::Result InvokeWorker(ApiId apiId, const void* pInBuffer, size_t inBufferSize, void* pOutBuffer, size_t outBufferSize);

//Handler向け
enum MultiWaitMode{
    MultiWaitMode_Full,//Api, Psc, Event
    MultiWaitMode_ApiPsc,
    MultiWaitMode_Psc,
    MultiWaitMode_Event,
    MultiWaitMode_TimedEvent,
};

MultiWaitId MultiWait(MultiWaitMode multiWaitMode, uint8_t timeoutSec = 0);
void FinishWorking();

//Impl, Handler向け
BtmState GetState();

}}
