﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/init.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>

#include <nn/btm/btm_Result.h>
#include <nn/btm/btm_Types.h>
#include "btm_Utility.h"

//#include <nn/bluetooth/bluetooth_Api.h>

namespace nn { namespace btm {

void PrintByteDataAsHex(const void* pBuffer, uint16_t length)
{
#ifdef BTM_ENABLE_LOG
    const uint8_t* buffer = reinterpret_cast<const uint8_t*>(pBuffer);
    uint8_t byteCount=0;
    NN_UNUSED( buffer );

    for(uint16_t i=0;i<length;i++)
    {
        NN_SDK_LOG("%02X ",buffer[i]);
        byteCount++;
        if(byteCount==16)
        {
            NN_SDK_LOG("\n");
            byteCount=0;
        }
    }
    if(byteCount!=0)
    {
        NN_SDK_LOG("\n");
    }
#else
    NN_UNUSED(pBuffer);
    NN_UNUSED(length);
#endif
}

bool IsSameBdAddress(const BdAddress* pBdAddressAlpha, const BdAddress* pBdAddressBeta)
{
    for(int i=0;i<SIZE_OF_BDADDRESS;i++)
    {
        if(pBdAddressAlpha->address[i] != pBdAddressBeta->address[i])
        {
            return false;
        }
    }
    return true;
}

bool IsSameBdAddress(const void* pBdAddressAlpha, const void* pBdAddressBeta)
{
    BdAddress bdAddressAlpha = *reinterpret_cast<const BdAddress*>(pBdAddressAlpha);
    BdAddress bdAddressBeta  = *reinterpret_cast<const BdAddress*>(pBdAddressBeta);
    return IsSameBdAddress(&bdAddressAlpha, &bdAddressBeta);
}

int64_t GetCurrentTimeMs()
{
    nn::os::Tick tick = nn::os::GetSystemTick();
    nn::TimeSpan timeSpan = nn::os::ConvertToTimeSpan(tick);
    NN_UNUSED(timeSpan);
    return timeSpan.GetMilliSeconds();
}

//--------------------------------------------------
//下層のリザルトを抽象化する
//--------------------------------------------------
nn::Result ConvertResult(nn::Result inResult)
{
    nn::Result result;
    /*
    NN_RESULT_TRY(inResult)
        NN_RESULT_CATCH(ResultInvalidArgument)
        {

        }
        NN_RESULT_CATCH(ResultFail)
        {

        }
        NN_RESULT_CATCH(ResultNotReady)
        {

        }
        NN_RESULT_CATCH(ResultB2)
        {

        }
        NN_RESULT_CATCH(ResultB)
        {

        }
        NN_RESULT_CATCH_ALL
        {
            // その他のエラー(多くの場合には想定外のため abort する)
        }
    NN_RESULT_END_TRY
    */

    if(inResult.IsFailure())
    {
        NN_DETAIL_BTM_INFO("Module: %d FalureFrom Bluetooth process.\n", inResult.GetModule());
        NN_DETAIL_BTM_INFO("Description: %d\n", inResult.GetDescription());
        NN_DETAIL_BTM_INFO("InnerValue: %d\n", inResult.GetInnerValueForDebug());
        //[Todo]下層のエラーコード整理が完了するまでは、固定値を返す
        result = ResultFailureLowLayerGeneral();
    }
    else
    {
        result = ResultSuccess();
    }

    return result;
}

}}
