﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once


namespace nn { namespace btm {

//Handler向け
bool CheckUsecase(const DeviceConditionList* pCurrentDcList, const DeviceConditionList* pNextDcList,
                  const GattClientConditionList* pCurrentGccList, const GattClientConditionList* pNextGccList,
                  SniffMode* pRecommendedSniffMode, SlotMode* pDefaultSlotMode, CeLength* pDefaultCeLength,
                  bool* pIsRestructureAllSlotsNeeded, uint8_t* pRestructureBleSlotsCount);

bool CheckUsecase(const DeviceConditionList* pCurrentDcList, const DeviceConditionList* pNextDcList,
                  const GattClientConditionList* pCurrentGccList, const GattClientConditionList* pNextGccList,
                  SlotMode* pDefaultSlotMode, CeLength* pDefaultCeLength,
                  bool* pIsRestructureAllSlotsNeeded, uint8_t* pRestructureBleSlotsCount);

TsiMode GetRecommendedTsi(SniffMode sniffMode, SlotMode slotMode);

CeLength GetDefaultCeLength(const DeviceConditionList* pDeviceConditionList, const GattClientConditionList* pGattClientConditionList);

uint8_t GetConnectionCapacity(const DeviceConditionList* pCurrentDcList, const GattClientConditionList* pCurrentGccList);

uint8_t GetBleConnectionCapacity(const DeviceConditionList* pCurrentDcList, const GattClientConditionList* pCurrentGccList);

//HandlerからのDebug向け
void DebugPrintUsecase(const DeviceConditionList* pDcList, const GattClientConditionList* pGccList);
}}
