﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <btm_InternalTypes.h>
#include "btm_Worker.h"

namespace nn { namespace btm {

struct Message{
    bool isUsing;
    ApiId apiId;
    uint8_t buffer[SIZE_OF_COMMAND_BUFFER];
};

void InitializeQueue();
void FinalizeQueue();
void EnQueue(const Message* pMessage);
void DeQueue(Message* pMessage);

}}
