﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once


namespace nn { namespace btm {

//Worker向け
BtmState InitializeHandler(nn::os::SystemEventType* pCoreEvent, nn::os::SystemEventType* pHidEvent, nn::os::SystemEventType* pBleCoreEvent);
void FinalizeHandler(nn::os::SystemEventType* pCoreEvent, nn::os::SystemEventType* pHidEvent, nn::os::SystemEventType* pBleCoreEvent);

void HandleBtHidReport(void);
void HandleBtCoreReport(void);
void HandleBtBleCoreReport(void);
void HandleApi(ApiId commandId, const void* pCommand, size_t commandSize,
        void* pReport, size_t reportSize, nn::Result* pResult);

void HandleSleep();
void HandleAwake();
void HandleShutdown();

//Impl向け
DevicePropertyList GetDevicePropertyList(void);
DeviceConditionList GetDeviceConditionList(void);
DeviceInfoList GetDeviceInfoList(void);
HostDeviceProperty GetHostDeviceProperty(void);
bool    GetScanFilterParameter(user::BleAdvFilterForGeneral* pFilter, uint16_t parameterId);
bool    GetScanFilterParameter(user::BleAdvFilterForSmartDevice* pFilter, uint16_t parameterId);
uint8_t GetScanResultGeneral(user::ScanResult *pResults, uint8_t inNum, const nn::applet::AppletResourceUserId& aruid);
uint8_t GetScanResultSmartDevice(user::ScanResult *pResults, uint8_t inNum, const nn::applet::AppletResourceUserId& aruid);
uint8_t GetScanResultUnconnectableScan(user::ScanResult *pResults, uint8_t inNum);
uint8_t GetScanResultSmartDeviceUnconnectableScan(user::ScanResult *pResults, uint8_t inNum);
uint8_t GetBleConnectionState(user::BleClientConnState *pConnState, uint8_t inNum);
GattClientConditionList GetGattClientConditionList();
uint8_t GetGattServices(user::GattService *pServices, uint8_t inNum, uint32_t connectionHandle);
uint8_t GetGattCharacteristics(user::GattCharacteristic *pCharacteristics, uint8_t inNum, uint32_t connectionHandle, uint16_t serviceHandle);
uint8_t GetGattDescriptors(user::GattDescriptor *pDescriptors, uint8_t inNum, uint32_t connectionHandle, uint16_t charHandle);
uint16_t GetBleMtu(uint32_t connectionHandle);
bool    IsConfiguringBleMtu();
bool    GetBlePairingSupported(uint32_t connectionHandle);
bool    GetBlePairingOnGoing();
uint8_t GetBlePairedDeviceAddress(BdAddress* pAddresses, uint8_t inNum, const user::BleAdvFilterForGeneral& filter);

bool IsGamepadPairingStarted(void);
bool IsRadioEnabled(void);
bool IsLlrStarted(void);
GeneralInfoList GetGeneralInfo(int mode);

void RegisterAppletResourceUserId(const nn::applet::AppletResourceUserId& aruid,
                                  uint32_t appletId);
void UnregisterAppletResourceUserId(const nn::applet::AppletResourceUserId& aruid);
void SetForeGroundAppletResourceUserId(const nn::applet::AppletResourceUserId& aruid);

bool GetBleDisconnectionReason(uint16_t* pOutReason, uint32_t connectionHandle, const BdAddress& address);
bool GetBleConnectionParameter(uint16_t* pOutInterval, uint16_t* pOutLatency, uint16_t* pOutTimeout, uint32_t connectionHandle);
bool GetBleConnectionParameterRequest(uint16_t* pOutIntervalMin, uint16_t* pOutIntervalMax, uint16_t* pOutLatency, uint16_t* pOutTimeout, uint32_t connectionHandle);

}}
