﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Thread.h>

#include "boot_BootReason.h"
#include "boot_Display.h"
#include "boot_DisplayImageBinary.h"
#include "boot_SplashScreen.h"

namespace nn { namespace boot {

    namespace
    {
#if defined NN_BOOT_BUILD_TYPE_DEV_UPDATER
        void ShowDevUpdater() NN_NOEXCEPT
        {
            const auto DevUpdaterSignageSpan = nn::TimeSpan::FromSeconds(4);

            nn::boot::SetupDisplay();
            nn::boot::ShowDisplay(
                DevUpdaterPointX, DevUpdaterPointY,
                DevUpdaterWidth, DevUpdaterHeight,
                reinterpret_cast<const Bit32*>(DevUpdaterData), DevUpdaterDataSize);
            nn::os::SleepThread(DevUpdaterSignageSpan);
            nn::boot::ShutdownDisplay();
        }
#else
        void ShowColdBoot() NN_NOEXCEPT
        {
#if defined(NN_BOOT_BUILD_TYPE_SAFE_MODE)
            const auto ColdBootSignageSpan = nn::TimeSpan::FromSeconds(3);
#else
            const auto ColdBootSignageSpan = nn::TimeSpan::FromSeconds(2);
#endif

            nn::boot::SetupDisplay();
            nn::boot::ShowDisplay(
                ColdBootPointX, ColdBootPointY,
                ColdBootWidth, ColdBootHeight,
                reinterpret_cast<const Bit32*>(ColdBootData), ColdBootDataSize);
            nn::os::SleepThread(ColdBootSignageSpan);
            nn::boot::ShutdownDisplay();
        }
#endif
    }
    // anonymous namespace

    void ShowSplashScreen() NN_NOEXCEPT
    {
        auto bootReason = nn::boot::GetBootReason();

        if (bootReason != nn::spl::BootReason_RtcAlarm2 && bootReason != nn::spl::BootReason_AcOk)
        {
#if defined NN_BOOT_BUILD_TYPE_DEV_UPDATER
            ShowDevUpdater();
#else
            ShowColdBoot();
#endif
        }
    }

}} // namespace nn::boot
