﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/spl/spl_Api.h>

#include "boot_SplAccessor.h"

namespace nn { namespace boot {

nn::spl::HardwareType GetHardwareType() NN_NOEXCEPT
{
    nn::Bit64 config;
    nn::spl::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::spl::GetConfig(&config, nn::spl::ConfigItem_HardwareType));
    nn::spl::Finalize();
    return static_cast<nn::spl::HardwareType>(config);
}

nn::spl::SocType GetSocType() NN_NOEXCEPT
{
    nn::spl::Initialize();
    auto socType = nn::spl::GetSocType();
    nn::spl::Finalize();
    return socType;
}

void SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT
{
    nn::spl::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::spl::SetBootReason(bootReason));
    nn::spl::Finalize();
}

bool IsRecoveryBoot() NN_NOEXCEPT
{
    nn::Bit64 config;
    nn::spl::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::spl::GetConfig(&config, nn::spl::ConfigItem_IsRecoveryBoot));
    nn::spl::Finalize();
    return static_cast<bool>(config);
}

}}  // namespace nn::boot
