﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/i2c/driver/i2c.h>

namespace nn { namespace boot {

class RtcDriver
{
public:
    RtcDriver() NN_NOEXCEPT
    {
        nn::i2c::driver::Initialize();
        nn::i2c::driver::OpenSession(&m_I2cSession, nn::i2c::I2cDevice_Max77620Rtc);
    }

    ~RtcDriver() NN_NOEXCEPT
    {
        nn::i2c::driver::CloseSession(m_I2cSession);
        nn::i2c::driver::Finalize();
    }

    nn::Result GetRtcInt(uint8_t* pOut) NN_NOEXCEPT;
    nn::Result GetRtcIntM(uint8_t* pOut) NN_NOEXCEPT;
    nn::Result MaskRtcAlarm() NN_NOEXCEPT;

private:
    nn::Result ReadDoubleBufferedRegister(uint8_t* pOut, uint8_t address) NN_NOEXCEPT;
    nn::Result WriteDoubleBufferedRegister(uint8_t address, uint8_t value) NN_NOEXCEPT;

private:
    nn::i2c::driver::I2cSession m_I2cSession;
};

}} // namespace nn::boot
