﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os.h>
#include <nn/dd.h>
#include <nn/nn_SdkLog.h>

namespace nn {
namespace boot {

namespace
{
const nn::dd::PhysicalAddress   PmcPhysicalAddress   = 0x07000e400ull;

const uintptr_t OffsetOfApbdevPmcClkOutCtrl          = 0x1a8;

const int Clk1ForceEnBit = 2;
const int Clk1SrcSelBit1 = 6;
const int Clk1SrcSelBit2 = 7;

inline void WriteMasked32( dd::PhysicalAddress address, Bit32 value, Bit32 mask)
{
    dd::ReadModifyWriteIoRegister(address, value, mask);
}

}

void SetInitialClockOutSetting() NN_NOEXCEPT
{
    dd::PhysicalAddress ApbdevPmcClkOutCtrlAddress = PmcPhysicalAddress + OffsetOfApbdevPmcClkOutCtrl;


    // NX 向けには Audio CODEC に外部クロックを供給する必要があるので、ここで設定
    // 設定値
    // CLK1_ACCEPT_REQ | DEFAULT
    // CLK1_INVERT_REQ | DEFAULT
    // CLK1_FORCE_EN   | 0x01
    // CLK1_RESERVED   | DEFAULT
    // CLK1_IDLE_STATE | DEFAULT
    // CLK1_SRC_SEL    | CAR (0x03)
    WriteMasked32(ApbdevPmcClkOutCtrlAddress,
                   0x01 << Clk1ForceEnBit |
                   0x03 << Clk1SrcSelBit1,
                   0x01 << Clk1ForceEnBit |
                   0x01 << Clk1SrcSelBit1 |
                   0x01 << Clk1SrcSelBit2
      );

    NN_SDK_LOG("[boot] Set Initial Clock Out Setting\n");
}

}}  // namespace nn::boot
