﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/nn_SdkLog.h>
#include <nn/dd/dd_IoMappingAddress.h>
#include <nn/os/os_Thread.h>

#include <t21x/arclk_rst.h>
#include "reg.h"

#include "boot_BatteryChargeChecker.h"
#include "boot_ClockChecker.h"

namespace nn { namespace boot {

namespace {

const auto PmicOscillatorStartupTimeMax = nn::TimeSpan::FromSeconds(1);

bool IsExpectedUsbPll() NN_NOEXCEPT
{
    const auto NN_BLSM_REG_CAR = nn::dd::QueryIoMappingAddress(0x60006000, 0x1000);

    const auto pllu = NN_REG_READ(CAR, CLK_RST_CONTROLLER_PLLU_BASE);
    if (NN_REG_EXTRACT_BITS(pllu, CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM) != 2)
    {
        return false;
    }
    if (NN_REG_EXTRACT_BITS(pllu, CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN) != 25)
    {
        return false;
    }
    if (NN_REG_EXTRACT_BITS(pllu, CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVP) != 1)
    {
        return false;
    }

    const auto spare = NN_REG_READ(CAR, CLK_RST_CONTROLLER_UTMIP_PLL_CFG0);
    if (NN_REG_EXTRACT_BITS(spare, CLK_RST_CONTROLLER_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV) != 25)
    {
        return false;
    }
    if (NN_REG_EXTRACT_BITS(spare, CLK_RST_CONTROLLER_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV) != 1)
    {
        return false;
    }

    return true;
}

} // namespace

void CheckClock() NN_NOEXCEPT
{
    if (!IsExpectedUsbPll())
    {
        // USB PLL が想定外の設定の場合 PMIC の安定を待って再起動
        nn::os::SleepThread(PmicOscillatorStartupTimeMax);
        NN_SDK_LOG("[boot] Unexpected USB PLL detected. Reboot now.\n");
        nn::boot::RebootSystem();
    }
}

}} // namespace nn::boot
