﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "bsa_disc_api.h"

/*******************************************************************************
**
** Function:        BtHalLeStartScan
**
** Description:     Start BLE Scan.
**
** Parameters:      [in] uint32_t duration : 0 means infinite scan, which stops when BtHalLeStopScan is called.
**
** Returns:         BluetoothLeStatus
**
** Callbacks:       InfoFromLeScanStateChangedCallback
**
*******************************************************************************/
BluetoothLeStatus BtHalLeStartScan(uint32_t duration);

/*******************************************************************************
**
** Function:        BtHalLeStopScan
**
** Description:     Stop BLE Scan.
**
** Parameters:      None
**
** Returns:         BluetoothLeStatus
**
** Callbacks:       InfoFromLeScanStateChangedCallback
**
*******************************************************************************/
BluetoothLeStatus BtHalLeStopScan();
