﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "bt_target.h"

/* for BSA functions and types */
#include "bsa_api.h"
/* for tAPP_XML_REM_DEVICE */
#include "xml_param.h"

/* APP HH callback functions */
typedef BOOLEAN (tAPP_HH_EVENT_CBACK)(tBSA_HH_EVT event, tBSA_HH_MSG *p_data);
typedef BOOLEAN (tAPP_HH_CUSTOM_UIPC_CBACK)(BT_HDR *p_msg);
typedef void (tAPP_HH_ADD_DEV_CBACK)(tBSA_HH_ADD_DEV *p_params, tAPP_XML_REM_DEVICE *p_device);

#define tAPP_HH_UIPC_CBACK tAPP_HH_CUSTOM_UIPC_CBACK /* For backward compatibility */

#ifndef APP_HH_SEC_DEFAULT
#define APP_HH_SEC_DEFAULT BSA_SEC_NONE
#endif

extern bool bonding_connect;

/*******************************************************************************
 **
 ** Function        _BsaHalIfInitHh
 **
 ** Description     robson HH initialization function
 **
 ** Parameters      none
 **
 ** Returns         status: 0 if success / -1 otherwise
 **
 *******************************************************************************/
int BtHalBsaInitHh();

/*******************************************************************************
 **
 ** Function        _BsaHalIfStartHh
 **
 ** Description     robson HH start function
 **
 ** Parameters      none
 **
 ** Returns         status: 0 if success / -1 otherwise
 **
 *******************************************************************************/
int BtHalBsaStartHh();

/*******************************************************************************
 **
 ** Function        app_hh_exit
 **
 ** Description     HH exit function
 **
 ** Parameters      none
 **
 ** Returns         status: 0 if success / -1 otherwise
 **
 *******************************************************************************/
int BtHalBsaExitHh();
