﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/lr/lr_Service.h>

#ifndef NN_PROCESS_AM_USE_LR_REDIRECT
    #error
#endif

#define HOST_ROOT "D:/home/Workspace/siglo/feature_tree/sdk/"
#define PLATFORM "NX-NXFP2-a64"
#define BUILD_TYPE "Develop"

void SetupLrRedirectForTest() NN_NOEXCEPT
{
    #define REDIRECT(programId, name) resolver.RedirectProgramPath({programId}, {"@Host:/" HOST_ROOT "Tests/Outputs/" PLATFORM "/Tests/" name "/" BUILD_TYPE "/" name ".nca"})
    nn::lr::Initialize();
    nn::lr::LocationResolver resolver;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::lr::OpenLocationResolver(&resolver, nn::ncm::StorageId::BuildInSystem));
    REDIRECT(0x0005000c10000000, "OeApplication");
    REDIRECT(0x0100000000001001, "AeLibraryApplet1");
    REDIRECT(0x0100000000001002, "AeLibraryApplet2");
    REDIRECT(0x0100000000001003, "AeLibraryApplet3");
    REDIRECT(0x0100000000001004, "AeLibraryApplet4");
    REDIRECT(0x0100000000001005, "AeLibraryApplet5");
    REDIRECT(0x010000000000100C, "AeOverlayApplet");
    REDIRECT(0x010000000000100A, "AeLibraryAppletAlone");
    REDIRECT(0x0100000000001012, "AeStarter");

    nn::lr::Finalize();
}
