﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dauth/dauth_ServiceResource.h>
#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>

namespace nn {

/* 動作させるアカウントサービスのコンフィギュレーションを決定する。 ----------------------------------------------*/
using DauthResourceType = dauth::DefaultServiceResource;

/* サービススレッドの資源 ----------------------------------------------------------------------------*/
static const int DauthSessionCountMax = 16;
static const int DauthPortCountMax = 1;
struct DauthServerOption
{
    static const bool CanDeferInvokeRequest = false;
    static const int ObjectInSubDomainCountMax = 16 * 8;
    static const size_t PointerTransferBufferSize = 4096;
    static const int SubDomainCountMax = 16;
};
class DauthServer
    : public sf::HipcSimpleAllInOneServerManager<DauthSessionCountMax, DauthPortCountMax, DauthServerOption>
{
};
const size_t DauthServerThreadStackSize = 4 * 4096;
const size_t DauthExecThreadStackSize = 4 * 4096;

// サーバーの開始と終了
Result StartDauthServer(DauthResourceType& resource) NN_NOEXCEPT;
void StopDauthServer() NN_NOEXCEPT;

} // ~namespace nn
