﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <new>
#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/fs/fs_ApiPrivate.h>
#include "../../Libraries/lm/impl/lm_LogServerProxy.h"

extern "C" void nninitInitializeAbortObserver()
{
}

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

void* operator new(size_t size)
{
    return std::malloc(size);
}

void* operator new(size_t size, const std::nothrow_t&) NN_NOEXCEPT
{
    return std::malloc(size);
}

void operator delete(void* ptr) NN_NOEXCEPT
{
    std::free(ptr);
}

void operator delete(void* ptr, const std::nothrow_t&) NN_NOEXCEPT
{
    std::free(ptr);
}

void* operator new[](size_t size)
{
    return std::malloc(size);
}

void* operator new[](size_t size, const std::nothrow_t&) NN_NOEXCEPT
{
    return std::malloc(size);
}

void operator delete[](void* ptr) NN_NOEXCEPT
{
    std::free(ptr);
}

void operator delete[](void* ptr, const std::nothrow_t&) NN_NOEXCEPT
{
    std::free(ptr);
}

namespace nn { namespace lm { namespace impl {
    void InitializeFlushThread() NN_NOEXCEPT;
    void FinalizeFlushThread() NN_NOEXCEPT;
    void InitializeIpcServer() NN_NOEXCEPT;
    void LoopIpcServer() NN_NOEXCEPT;
    void FinalizeIpcServer() NN_NOEXCEPT;
}}} // nn::lm::impl

extern "C" void nnMain()
{
    nn::os::ChangeThreadPriority(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_PRIORITY(lm, IpcServer));
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(lm, IpcServer));

#if !defined(NN_DETAIL_LM_FOR_PRODUCT)
    nn::fs::InitializeWithMultiSessionForSystem();

    #if !defined(NN_DETAIL_LM_WITHOUT_TMA)
    nn::lm::impl::LogServerProxy::GetInstance().Start();
    #endif
    nn::lm::impl::InitializeFlushThread();
#endif
    nn::lm::impl::InitializeIpcServer();
    nn::lm::impl::LoopIpcServer();
    nn::lm::impl::FinalizeIpcServer();
#if !defined(NN_DETAIL_LM_FOR_PRODUCT)
    nn::lm::impl::FinalizeFlushThread();
    #if !defined(NN_DETAIL_LM_WITHOUT_TMA)
    nn::lm::impl::LogServerProxy::GetInstance().Stop();
    #endif
#endif
}
