﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/nn_SdkLog.h>

#include <nn/dmnt0/detail/dmnt0_Interface.h>
#include <nn/dmnt0/dmnt0_Api.h>

#include <nn/os/os_Thread.h>

#include "dmnt_ServerMain.h"
#include "dmnt_Server.h"

using namespace nn;

namespace
{
    const int MaxSessionCount = 1;
    const int PortCount = 1;

    class ServerManager : public nn::sf::HipcSimpleAllInOneServerManager<MaxSessionCount, PortCount>
    {
    private:
        virtual nn::Result OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT;
    };


    NN_ALIGNAS(64) nn::Bit8 s_DefaultServerAllocatorBuffer[16 * 1024];

    nn::sf::ExpHeapAllocator  s_DefaultServerAllocator;
    ServerManager g_ServerManager;

    NN_ALIGNAS(nn::os::StackRegionAlignment) nn::Bit8 s_Stack[16 * 1024];
    nn::os::ThreadType s_Thread;



    nn::Result ServerManager::OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT
    {
        NN_UNUSED(portIndex);

        nn::sf::SharedPointer<nn::dmnt0::detail::IInterface> refInterface;

        refInterface = nn::sf::ObjectFactory<
            nn::sf::ExpHeapAllocator::Policy
        >::CreateSharedEmplaced<
            nn::dmnt0::detail::IInterface,
            Server
        >(&s_DefaultServerAllocator);

        return this->AcceptImpl(pPort, refInterface);
    }


    void ThreadBody(void*) NN_NOEXCEPT
    {
        auto heapHandle = nn::lmem::CreateExpHeap(&s_DefaultServerAllocatorBuffer, sizeof(s_DefaultServerAllocatorBuffer), nn::lmem::CreationOption_NoOption);
        s_DefaultServerAllocator.Attach(heapHandle);

        nn::Result result;

        result = g_ServerManager.InitializePort(0, 1, nn::dmnt0::detail::PortName);
        NN_ABORT_UNLESS(result.IsSuccess(), "result=%08x", result);

        g_ServerManager.Start();
        g_ServerManager.LoopAuto();
    }
}

void StartServer() NN_NOEXCEPT
{
    nn::os::CreateThread(&s_Thread, ThreadBody, NULL, s_Stack, sizeof(s_Stack), 16);
    nn::os::StartThread(&s_Thread);
}
