﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "dmnt_DebugMonitor.h"

namespace nn { namespace dmnt { namespace rsp {
const size_t BUFFER_SIZE = 0x4000;

class PacketParser
{
public:
    PacketParser(char* pRecvPacket, char* pReplyPacket, DebugProcess *pProcess) :
        m_pReceivedPacket(pRecvPacket), m_pReplyPacket(pReplyPacket), m_pDebugProcess(pProcess), m_NoAckIsSet(false)
    {}
    void Process();
    uint32_t GetLastThreadId();
    void  SetLastSignal(uint32_t sig);
    uint32_t GetLastSignal();
    uint32_t GetContinueThreadId();
    void  ClearContinueThreadId();
    bool IsSetNoAck() const;

private:
    uint32_t RegNumToContextFlag(int32_t regNum);
    static int HexToInteger(char ch);
    static int HexToInteger(char *p);
    static void Mem2Hex(char* buf, const void* mem, size_t size);
    static void Hex2Mem(void *mem, const char* buf, size_t size);
    void ToGdbRegister(char* pBuffer, nn::svc::ThreadContext* pContext);
    void ToGdbRegister(char* pBuffer, nn::svc::ThreadContext* pContext, int32_t regNum);
    void UpdateGdbRegister(nn::svc::ThreadContext* pContext, char* pString);
    void UpdateGdbRegister(nn::svc::ThreadContext* pContext, char* pString, int32_t regNum);

    void Continue(uint32_t tid);
    void Continue();
    void Step(uint32_t tid);
    void Step();

    char* m_pReceivedPacket;
    char* m_pReplyPacket;
    bool m_NoAckIsSet;
    DebugProcess *m_pDebugProcess;
    void Z();
    void z();
    void v();
    void Q();
    void C();
    void q();
    void p();
    void P();
    void c();
    void g();
    void G();
    void H();
    void M();
    void m();
    void T();
    void k();
    void D();
    void Hg();
    void Hc();
    void HG();
    void qfThreadInfo();
    void qsThreadInfo();
    void qSupported();
    void qTStatus();
    void qAttached();
    void qXferFeaturesRead();
    void qOffsets();
    void qStartNoAckMode();
    void qXferLibrariesRead();
    void LastSignal();
    Result ParseVCont(char * const token, uint32_t *threadIds, uint8_t *threadActions, int32_t numThreads, nn::dmnt::ContinueMode &defaultAction);
// M, m コマンド用の一時バッファ
    char m_Buffer[BUFFER_SIZE / 2];

};

}}}
