﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include "dmnt_DebugIO.h"

namespace nn { namespace dmnt { namespace rsp {

class RspPacket
{
private:
    class InternalMutex
    {
    public:
        void Initialize()
        {
            nn::os::InitializeMutex(&m_Mutex, false, 0);
        }
        void Finalize()
        {
            nn::os::FinalizeMutex(&m_Mutex);
        }
        void lock()
        {
            nn::os::LockMutex(&m_Mutex);
        }
        void unlock()
        {
            nn::os::UnlockMutex(&m_Mutex);
        }
    private:
        nn::os::MutexType m_Mutex;
    };
    InternalMutex m_Mutex;
    bool mNoAck;

public:
    RspPacket()
    : mNoAck(false)
    {
    }
    void Initialize()
    {
        mNoAck = false;
        m_Mutex.Initialize();
    }
    void Finalize()
    {
        m_Mutex.Finalize();
    }
    void SetNoAck();
    void SendPacket(bool* pBreak, const char* pBuffer, nn::dmnt::io::DebugSession *pSession);
    char* ReceivePacket(bool* pBreak, char* pBuffer, size_t size, nn::dmnt::io::DebugSession *pSession);
};

}}}
