﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_FormatString.h>
#include <nn/os.h>
#include <nn/osdbg.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dmnt.h>

#include "dmnt_DebugMonitor.h"
#include "dmnt_OsDebug.h"

namespace nn { namespace dmnt { namespace osdbg {

//----------------------------------------------------------------------------

void PrintAllThreadInfo(nn::osdbg::ThreadInfo* threadInfoArray[], int numThreads)
{
//----------------------------------------------------------------------------
//  TORIAEZU:
//
//  gdbserver がホストから "qfThreadInfo" パケットを受理した時に、
//  デバッグ対象プロセスのスレッド情報を osdbg ライブラリを使って取得するので、
//  その取得したスレッド情報一覧を表示する関数です。
//
//  動作はするものの、アプリのログ出力を汚すので #if 0 で無効化。
//----------------------------------------------------------------------------
//  TEMPORARY:
//
//  This function outputs threads information of the debug target process
//  to NN_SDK_LOG() console. A first argument "threadInfoArray[]" must be
//  already filled with threads information beforehand by calling
//  nn::osdbg::InitializeThreadInfo().
//
//  This code is usually disabled in order not to get application's log dirty.
//----------------------------------------------------------------------------

#if 1
    NN_UNUSED(threadInfoArray);
    NN_UNUSED(numThreads);
#else
    NN_SDK_LOG("\n");
    NN_SDK_LOG("numThreads=%d\n\n", numThreads);

    NN_SDK_LOG("[ThreadType] BPri CPri Stack    StkSize  Function Argument Name\n");
    NN_SDK_LOG("-------------------------------------------------------------------------------\n");
    for (int i = 0; i < numThreads; i++)
    {
        char buf[256];

        nn::osdbg::ThreadInfo* info = threadInfoArray[i];
        auto result = nn::osdbg::UpdateThreadInfo(info);
        if (!result.IsSuccess())
        {
            nn::util::SNPrintf(buf, sizeof(buf),
                "[0x%08p] ---- ---- -------- -------- -------- -------- ?\n",
                info->_threadType);
            NN_SDK_LOG(buf);
            continue;
        }

        char name[32];
        name[0]  = '\0';
        nn::svc::ReadDebugProcessMemory(reinterpret_cast<uintptr_t>(name),
                                        info->_debugHandle,
                                        nn::osdbg::GetThreadNamePointer(info),
                                        sizeof(name));
        name[31] = '\0';

        nn::util::SNPrintf(buf, sizeof(buf),
                "[0x%08p] %4d %4d %08p %08p %08p %08p %s\n",
                info->_threadType,
                nn::osdbg::GetThreadPriority(info),
                nn::osdbg::GetThreadCurrentPriority(info),
                nn::osdbg::GetThreadStackAddress(info),
                nn::osdbg::GetThreadStackSize(info),
                nn::osdbg::GetThreadFunction(info),
                nn::osdbg::GetThreadFunctionArgument(info),
                name);

        NN_SDK_LOG(buf);
    }
    NN_SDK_LOG("\n");
#endif
}

//----------------------------------------------------------------------------

}}} // name nn::dmnt::osdbg

