﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <cstring>

namespace nn { namespace dmnt {
enum
{
    MAX_NUMBER_OF_MODULES_QUERY = 16,
    MAX_PATH = 260
};


class ModuleDefinition
{
public:
    ModuleDefinition();
    ~ModuleDefinition();

    void Clear();
    // Operators
    bool operator !=  (const ModuleDefinition& Definition) const;
    ModuleDefinition&  operator = (const ModuleDefinition& List);

    //Fetch info
    char* GetNameBuffer()
    {
        return m_Name;
    }

    char const * GetName() const
    {
        return m_Name;
    }

    void SetAddressSize(uint64_t address, uint64_t size)
    {
        m_Address = address;
        m_Size = size;
    }

    uint64_t GetAddress() const { return m_Address; }
    uint64_t GetSize() const { return m_Size; }

    enum
    {
        MODULE_ID_SIZE = 32
    };

protected:
    char m_Name[MAX_PATH];
    uint64_t m_Address;
    uint64_t m_Size;
};

}}

