﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_DevelopApi.h>
#include <nn/ldr/ldr_DebugMonitorApi.h>
#include <nn/util/util_FormatString.h>
#include <nn/svc/svc_Synchronization.h>
#include <nn/svc/svc_Result.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Base.h>
#include <nn/osdbg.h>
#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/ldr/ldr_Types.h>
#include <nn/dmnt/dmnt_Result.h>
#include <nn/dbg/dbg_Api.h>
#include <mutex>
#include <cstring>
#include <alloca.h>
#include "gdbserver_log.h"
#include "dmnt_Rsp.h"
#include "dmnt_ModuleDefinition.h"
#include "dmnt_DebugMonitor.h"
#include "dmnt_ArraySize.h"

namespace nn { namespace dmnt {

ModuleDefinition::ModuleDefinition()
{
    Clear();
}

void ModuleDefinition::Clear()
{
    memset( m_Name, 0, sizeof(m_Name) );
    m_Address   = 0;
    m_Size      = 0;
}

ModuleDefinition::~ModuleDefinition()
{
}

bool ModuleDefinition::operator != ( const ModuleDefinition& Definition ) const
{
    // Same load address and size?
    if( m_Address == Definition.m_Address )
    {
        if( m_Size == Definition.m_Size )
        {
            //Made it here, so we passed all tests - We're equal
            if( strcmp( m_Name, Definition.m_Name ) == 0 )
            {
                return false;
            }
        }
    }

    // Not equal
    return true;
}

ModuleDefinition& ModuleDefinition::operator=( const ModuleDefinition& Definition )
{
    m_Address    = Definition.m_Address;
    m_Size  = Definition.m_Size;
    memcpy( m_Name, Definition.m_Name, sizeof(m_Name) );

    return *this;
}

}}

