﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Dmnt.h>
#include "BreakPointManagerBase.h"

namespace nn { namespace dmnt {

struct WatchPoint : public BreakPointBase
{
    nn::svc::HardwareBreakPointRegisterName m_RegNumber;
    nn::svc::HardwareBreakPointRegisterName m_RegContext;
    bool m_ReadAccess;
    bool m_WriteAccess;

    void Initialize(nn::svc::HardwareBreakPointRegisterName reg, nn::svc::HardwareBreakPointRegisterName ctxReg)
    {
        m_RegNumber = reg;
        m_RegContext = ctxReg;
    }

    virtual nn::Result Clear(DebugProcess *debugProcess);
    nn::Result Set(DebugProcess *debugProcess, uintptr_t addr, size_t len, bool readAccess, bool writeAccess);
};


class HardwareWatchPoints : public BreakPointManagerBase
{
public:
    explicit HardwareWatchPoints(DebugProcess *debugProcess);
    static const int NUM_BREAKPOINT = 16;

    nn::Result SetWatchPoint(nn::Bit64 addr, nn::Bit64 len, bool readAccess, bool writeAccess) NN_NOEXCEPT;
    nn::Result GetWatchPointInfo(nn::Bit64 addr, bool &readAccess, bool &writeAccess) NN_NOEXCEPT;
    static bool IsValidWatch(nn::Bit64 address, nn::Bit64 len);
private:
    WatchPoint m_BreakPoints[NUM_BREAKPOINT];

    virtual BreakPointBase *GetBreakPoint(unsigned index);
    WatchPoint *GetFreeBreak();
};

}}

