﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "BreakPointManagerBase.h"

namespace nn { namespace dmnt {

class DebugProcess;

struct BreakPoint : public BreakPointBase
{
    bool m_IsStep;

    BreakPoint()
    {
    }

    void Reset()
    {
        m_InUse = false;
    }

    virtual nn::Result Set(DebugProcess *debugProcess, uintptr_t addr, size_t len, bool isStep) = 0;
};

class BreakPointManager : public BreakPointManagerBase
{
public:
    explicit BreakPointManager(DebugProcess *debugProcess);
    Result Initialize();
    void ClearStep();
    nn::Result SetBreakPoint(uintptr_t addr, size_t len, bool isStep);
private:
};

}}

