﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <mutex>
#include <nn/os.h>
#include <nn/osdbg.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Synchronization.h>
#include <nn/svc/svc_Result.h>
#include <nn/util/util_FormatString.h>
#include <nn/dmnt/dmnt_Result.h>
#include "dmnt_Rsp.h"
#include "dmnt_DebugMonitor.h"
#include <alloca.h>
#include <cstring>
#include "gdbserver_log.h"

#include "dmnt_ArraySize.h"
#include "BreakPointManager.h"

namespace nn { namespace dmnt {

BreakPointManager::BreakPointManager(DebugProcess *debugProcess)
: BreakPointManagerBase(debugProcess)
{
}

void BreakPointManager::ClearStep()
{
    for (unsigned i = 0; GetBreakPoint(i) != nullptr; ++i)
    {
        BreakPoint *breakPoint((BreakPoint *)GetBreakPoint(i));
        if (breakPoint->m_InUse && breakPoint->m_IsStep)
        {
            GDB_TRACE_T("[BreakPointManager::ClearStep] Line:%d, Address:0x%llx, breakPoint=0x%llx, index:%d\n", __LINE__, breakPoint->m_Addr, breakPoint, i);
            breakPoint->Clear(m_pDebugProcess);
        }
    }
}

nn::Result BreakPointManager::SetBreakPoint(uintptr_t addr, size_t len, bool isStep)
{
    BreakPoint *breakPoint((BreakPoint *)GetFreeBreak());

    Result result = nn::svc::ResultMaxHandle(); // When there are too many break points

    if (breakPoint)
    {
        result = breakPoint->Set(m_pDebugProcess, addr, len, isStep);
    }
    if (!result.IsSuccess())
    {
        GDB_TRACE_T("BreakPointManager::SetBreakPoint @0x%llx, FAILED error:0x%x\n", addr, result.GetInnerValueForDebug());
    }

    return result;
}

}}
