﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/i2c/driver/i2c_Lib.h>
#include <nn/i2c/i2c_IManager.sfdl.h>
#include <nn/i2c/server/i2c_ManagerImpl.h>

#include "gpio/Bus_GpioDriver.h"
#include "gpio/Bus_GpioServer.h"
#include "pinmux/Bus_PinmuxServer.h"
#include "i2c/Bus_I2cDriver.h"
#include "i2c/Bus_I2cServer.h"
#include "uart/Bus_UartServer.h"
#include "pwm/Bus_PwmServer.h"
#include "sasbus/Bus_SasbusServer.h"

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

//-----------------------------------------------------------------------------

extern "C" void nnMain()
{
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(Bus, Main));

    /*
    ドライバサブシステム開始の流れ

    1. 各サブシステムのサーバ初期化
        - HIPC サーバ登録 (sm にクリティカルセクションがあるため、全サービスについて最初にやっておく）
    2. 各サブシステムライブラリの最小限の初期化（必要なら）
        - Step3 で各ドライバ実装が自身を登録できるための最小限のリソース初期化
    3. 各ドライバ実装ライブラリの初期化
        - ドライバオブジェクトの初期化メソッドのサブシステムへの登録
        - この時点ではハードウェアアクセスは禁止
    4. （未実装）デバイスコードノードのパース
        - 各ドライバ実装ライブラリからパーサオブジェクトを収集
        - ParseAll()
    5. 各サブシステムのサーバスレッド開始
        - サーバスレッドの冒頭で以下を行う
            1. サブシステムの開始
                - ドライバ実装の初期化ルーチン呼び出し
            2. サブシステムの HIPC ループ開始

    # メインスレッド上では他プロセスへの追加の依存を伴う処理は禁止
    */

    // 1. 各サブシステムのサーバ初期化
    nn::bus::gpio::InitializeServer();
    nn::bus::pinmux::InitializeServer();
    nn::bus::i2c::InitializeServer();
    nn::bus::uart::InitializeServer();
    nn::bus::pwm::InitializeServer();
    nn::bus::sasbus::InitializeServer();

    // 2. 各サブシステムライブラリの最小限の初期化（必要なら）
    // 現在は該当処理なし

    // 3. 各ドライバ実装ライブラリの初期化
    nn::bus::gpio::InitializeDriver();
    nn::bus::i2c::InitializeDriver();

    // 4. （未実装）デバイスコードノードのパース

    // 5. 各サブシステムのサーバスレッド開始
    nn::bus::gpio::StartServer();
    nn::bus::pinmux::StartServer();
    nn::bus::i2c::StartServer();
    nn::bus::uart::StartServer();
    nn::bus::pwm::StartServer();
    nn::bus::sasbus::StartServer();

    // ------------ 初期化・開始完了 ----------------

    // サーバ停止要求の待機をするならばここで行うが、現状ではそのようなトリガーは存在しない

    // サーバの停止（サーバスレッドを抜ける）
    // nn::bus::gpio::StopServer();
    // nn::bus::pinmux::StopServer();
    // nn::bus::i2c::StopServer();
    // nn::bus::uart::StopServer();
    // nn::bus::pwm::StopServer();
    // nn::bus::sasbus::StopServer();

    // サーバスレッド終了の待機 (ただし上で StopServer を無効にしているのでこれが返ることはない)
    nn::bus::gpio::WaitAndFinalizeServer();
    nn::bus::pinmux::WaitAndFinalizeServer();
    nn::bus::i2c::WaitAndFinalizeServer();
    nn::bus::uart::WaitAndFinalizeServer();
    nn::bus::pwm::WaitAndFinalizeServer();
    nn::bus::sasbus::WaitAndFinalizeServer();
}

//-----------------------------------------------------------------------------

