﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/xcd/xcd_Vibration.h>

namespace nn { namespace xcd {

class VibratorBase;

//!< 接続時の振動のパターンを表す列挙体
enum VibrationPatternOnConnect : uint8_t
{
    VibrationPatternOnConnect_None,         //!< 振動無し
    VibrationPatternOnConnect_JoyCon,       //!< ジョイコンの振動パターン
    VibrationPatternOnConnect_FullConLeft,  //!< フルコンの振動パターン（左）
    VibrationPatternOnConnect_FullConRight, //!< フルコンの振動パターン（右）
};

//!< 接続時の振動を表すクラス
class VibrationOnConnect final
{
    NN_DISALLOW_COPY(VibrationOnConnect);
    NN_DISALLOW_MOVE(VibrationOnConnect);

public:
    explicit VibrationOnConnect(VibratorBase* pParent) NN_NOEXCEPT :
        m_Pattern(VibrationPatternOnConnect_None),
        m_Position(0),
        m_Length(0),
        m_IsDevicePowerOn(false),
        m_pVibratorBase(pParent) {}
    ~VibrationOnConnect() NN_NOEXCEPT {}

    //!< 振動開始します
    void StartPlaying(VibrationPatternOnConnect pattern) NN_NOEXCEPT;

    //!< 次に送信すべき振動値を取得します
    VibrationValue GetNextVibration() NN_NOEXCEPT;

    //!< 現在振動を再生中か取得します
    bool IsPlaying() NN_NOEXCEPT;

    //!< 現在のアンプの電源状況を設定します
    void SetDevicePowerStatus(bool isDevicePowerOn) NN_NOEXCEPT;

private:
    VibrationPatternOnConnect m_Pattern;
    int m_Position;
    int m_Length;
    bool m_IsDevicePowerOn;
    VibratorBase* const m_pVibratorBase;
};

}} // namespace nn::xcd
