﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEventTypes.h>
#include "xcd_IrsensorProcessorBase.h"

namespace nn { namespace xcd {

//!< TeraPluginProcessor の実装クラス
class IrsensorTeraPluginProcessor final : public IrsensorProcessorBase
{
public:
    IrsensorTeraPluginProcessor() NN_NOEXCEPT :
        m_pTeraPluginProcessorState(nullptr)
    {}

    virtual ~IrsensorTeraPluginProcessor() NN_NOEXCEPT;

    //!< IRセンサのTeraPluginモードのデータをパースします。
    Result ParseTeraPluginData(const uint8_t* pBuffer, size_t size, uint8_t sampleNumber) NN_NOEXCEPT;
    //!< IRセンサのTeraPluginモードのワークバッファを設定します。
    Result SetupProcessor(IrCommonData* pIrCommonWorkBuffer, IrTeraPluginProcessorState* pTeraPluginProcessorWorkBuffer) NN_NOEXCEPT;
    //!< IRセンサのTeraPluginモードを終了し、ワークバッファを解放します。
    Result StopProcessor() NN_NOEXCEPT;
    //!< IRセンサのTeraPluginモードのデータを取得します。
    Result GetTeraPluginState(IrCommonData* pOutIrCommonData, IrTeraPluginProcessorState* pOutTeraPluginProcessorState) NN_NOEXCEPT;

private:
    static const size_t TeraPluginProcessorInputReportSize = 300; //!< TeraPluginモードのInputReportのサイズ

private:
    IrTeraPluginProcessorState* m_pTeraPluginProcessorState; //!< TeraPluginモードの出力結果のバッファポインタ
};

}} // namespace nn::xcd
