﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/xcd/xcd_ResultForPrivate.h>
#include "xcd_IrsensorBase.h"
#include "xcd_IrsensorProcessorBase.h"

namespace nn { namespace xcd {

IrsensorProcessorBase::~IrsensorProcessorBase() NN_NOEXCEPT
{
    // 何もしない
}

Result IrsensorProcessorBase::ParseIrsensorHeader(const uint8_t* pBuffer, size_t size, uint8_t sampleNumber) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);

    NN_UNUSED(size);
    NN_UNUSED(sampleNumber);

    if (!IsProcessorReady())
    {
        return nn::xcd::ResultIrProcessorNotReady();
    }

    // DataRead パケットにキャストする
    auto pDataReadInPacket = reinterpret_cast<const IrsensorDataReadInPacket*>(pBuffer);

    m_ResultCode = pDataReadInPacket->resultCode;
    m_IrCommonData[0].irProcessorType = static_cast<IrProcessorType>(pDataReadInPacket->dataType);
    m_IrCommonData[0].frameId = pDataReadInPacket->imageId;
    m_IrCommonData[0].averageIntensityOn = pDataReadInPacket->averageIntensityOn;
    m_IrCommonData[0].averageIntensityOff = pDataReadInPacket->averageIntensityOff;
    m_IrCommonData[0].lightPixelOn = pDataReadInPacket->lightPixelOn;
    m_IrCommonData[0].lightPixelOff = pDataReadInPacket->lightPixelOff;

    // Timestamp の取得
    m_DiffTimeStamp = (256 + pBuffer[InputReportTimeStampOffset] - m_TimeStamp) % 256;
    m_TimeStamp = pBuffer[InputReportTimeStampOffset];

    // 反映済みの RegWrite コマンドのID
    m_LatestAckCount = pDataReadInPacket->ackData.Get<nn::xcd::IrsensorAckDataPack::WriteRegAckCount>();

    NN_RESULT_SUCCESS;
}

bool IrsensorProcessorBase::IsProcessorReady() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);

    return m_IsProcessorReady;
}

}} // namespace nn::xcd
