﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_MultipleWait.h>

namespace nn { namespace xcd {


//!< オブジェクトからのシグナルで駆動するタスクを扱うクラスです
class IEventTask
{
    NN_DISALLOW_COPY(IEventTask);
    NN_DISALLOW_MOVE(IEventTask);

public:
    IEventTask() NN_NOEXCEPT { /* 何もしない */ };
    virtual ~IEventTask() NN_NOEXCEPT { /* 何もしない */ };

    virtual void EventFunction(const ::nn::os::MultiWaitHolderType* pMultiWaitHolder) NN_NOEXCEPT = 0;

    virtual void PeriodicEventFunction() NN_NOEXCEPT {}
};

}} // namespace nn::xcd
