﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_Mutex.h>
#include <nn/xcd/xcd_Device.h>
#include <nn/xcd/xcd_DeviceState.h>

namespace nn { namespace xcd {

class DeviceHandleGenerator final
{
    NN_DISALLOW_MOVE(DeviceHandleGenerator);
    NN_DISALLOW_COPY(DeviceHandleGenerator);

private:
    //!< ペアリング制御を排他するための Mutex
    nn::os::Mutex m_Mutex;

    //!< 最後に発行されたハンドル
    DeviceHandle m_LatestHandle;

    DeviceHandleGenerator() NN_NOEXCEPT
        : m_Mutex(false)
    {
        // 何もしない
    }
    ~DeviceHandleGenerator() NN_NOEXCEPT { /* 何もしない */ };

public:
    //!< ユニークなデバイスハンドルを取得する
    DeviceHandle GetDeviceHandle() NN_NOEXCEPT
    {
        ::std::lock_guard<decltype(m_Mutex)> locker(m_Mutex);
        m_LatestHandle._upper = m_LatestHandle._upper + 1;
        return m_LatestHandle;
    }

    //!< DeviceHandleGenerator を初期化する
    void Init() NN_NOEXCEPT
    {
        ::std::lock_guard<decltype(m_Mutex)> locker(m_Mutex);
        m_LatestHandle._upper = 0;
    }

    //!< ユニークなデバイスハンドルを取得する
    static DeviceHandleGenerator& Get() NN_NOEXCEPT
    {
        static DeviceHandleGenerator generator;
        return generator;
    }
};

}} // namespace nn::xcd
