﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/xcd/xcd_Pairing.h>

#include "xcd_Bluetooth.h"
#include "detail\xcd_BluetoothDriver.h"

namespace nn { namespace xcd {

detail::BluetoothDriver& GetBluetoothDriver() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(detail::BluetoothDriver, s_BluetoothDriver);

    return s_BluetoothDriver;
}

void ActivateBluetoothDriver() NN_NOEXCEPT
{
    GetBluetoothDriver().Activate();
}

void DeactivateBluetoothDriver() NN_NOEXCEPT
{
    GetBluetoothDriver().Deactivate();
}

void SetPairingUpdateEvent(::nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);
    GetBluetoothDriver().SetPairingUpdateEvent(pEvent);
}

void StartBluetoothButtonPairing() NN_NOEXCEPT
{
    GetBluetoothDriver().StartButtonPairing();
}

BluetoothDeviceInfo GetHostBluetoothDeviceInfo() NN_NOEXCEPT
{
    return GetBluetoothDriver().GetDeviceInfo();
}

bool IsRegisteredBluetoothDevice(const ::nn::bluetooth::Address address) NN_NOEXCEPT
{
    return GetBluetoothDriver().IsRegisteredDevice(address);
}

int GetRegisteredBluetoothDevices(BluetoothDeviceInfo pOutValues[], int length) NN_NOEXCEPT
{
    return GetBluetoothDriver().GetRegisteredDevices(pOutValues, length);
}

void RegisterBluetoothDevice(const BluetoothDeviceInfo& deviceInfo) NN_NOEXCEPT
{
    GetBluetoothDriver().RegisterBluetoothDevice(deviceInfo);
}

void IncreaseBluetoothDeviceInfoOrder(const ::nn::bluetooth::Address& address) NN_NOEXCEPT
{
    GetBluetoothDriver().IncreaseDeviceInfoOrder(address);
}

void ProtectBluetoothDeviceInfo(const ::nn::bluetooth::Address& address, bool protect) NN_NOEXCEPT
{
    GetBluetoothDriver().ProtectDeviceInfo(address, protect);
}

void SuspendBluetooth() NN_NOEXCEPT
{
    GetBluetoothDriver().Suspend();
}

void ResumeBluetooth() NN_NOEXCEPT
{
    GetBluetoothDriver().Resume();
}

::nn::Result TriggerBluetoothConnection(const ::nn::bluetooth::Address address, nn::os::EventType* pEvent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    NN_RESULT_DO(GetBluetoothDriver().SendConnectionTrigger(address, pEvent));
    NN_RESULT_SUCCESS;
}

}} // namespace nn::xcd::detail
