﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include "xcd_FirmwareUpdaterStream.h"
#include "xcd_TeraUpdaterTypes.h"

namespace nn { namespace xcd { namespace detail {

/**
 * @brief   Tera MCU の FW イメージを読み込むクラス
 */
class TeraUpdaterStream final : public FirmwareUpdaterStream
{
    NN_DISALLOW_COPY(TeraUpdaterStream);
    NN_DISALLOW_MOVE(TeraUpdaterStream);

public:
    TeraUpdaterStream() NN_NOEXCEPT
        : m_ImageInfo()
    {}

    /**
     * @brief   ストリームのセットアップ
     */
    nn::Result Setup(const FirmwareImage& image) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   FW イメージのサイズを取得
     */
    size_t GetImageSize() const NN_NOEXCEPT NN_OVERRIDE { return GetActualImageSize() - McuFirmwareImageHeaderSize; }

    /**
     * @brief   本来の FW イメージのサイズを取得
     */
    size_t GetActualImageSize() const NN_NOEXCEPT { return FirmwareUpdaterStream::GetImageSize(); }

    /**
     * @brief   FW イメージ情報を取得
     */
    void GetImageInfo(McuFirmwareImageInfo* pOutImageInfo) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutImageInfo);

        *pOutImageInfo = m_ImageInfo;
    }

    /**
     * @brief   FW イメージを読み込む
     */
    nn::Result Read(uint8_t* pOutBuffer, size_t* pOutReadLength, size_t readLength) NN_NOEXCEPT NN_OVERRIDE;

private:
    McuFirmwareImageInfo    m_ImageInfo;    //!< FW イメージの情報
};

}}}  // nn::xcd::detail
