﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd_Device.h>
#include <nn/xcd/xcd_DeviceState.h>

namespace nn { namespace xcd { namespace detail{

enum BluetoothTsi : uint8_t
{
    BluetoothTsi_Active = 0xff,
    BluetoothTsi_Up3Down1Sniff24 = 0x08,
    BluetoothTsi_Up1Down1Sniff8  = 0x01,
    BluetoothTsi_Up1Down1Sniff16 = 0x09,
    BluetoothTsi_Up1Down1Sniff24 = 0x10,
    BluetoothTsi_Up3Down3Sniff24 = 0x05,
};

struct HidDeviceInfo
{
    DeviceHandle deviceHandle;
    ::nn::bluetooth::Address address;
    int vid;
    int pid;
    InterfaceType interfaceType;
    DeviceType deviceType;
};

}}} // namespace nn::xcd::detail
